import os
import webbrowser
import threading

from app import create_app, db
from app import models

# Define persistent DB path before creating app
db_folder = os.path.join(os.getcwd(), 'user_data')
os.makedirs(db_folder, exist_ok=True)
db_path = os.path.join(db_folder, 'site.db')
db_uri = f"sqlite:///{db_path}"

# Now create app with DB URI
app = create_app(db_uri=db_uri)

def open_browser():
    webbrowser.open_new("http://127.0.0.1:5050")

def create_database_if_needed():
    with app.app_context():
        if not os.path.exists(db_path):
            db.create_all()
            print("✅ Database created.")
        else:
            print("🗃️ Database already exists.")

create_database_if_needed()
threading.Timer(1.0, open_browser).start()

if __name__ == "__main__":
    app.run(debug=True, port=5050, use_reloader=False)
